"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddAppointmentController = void 0;
const common_1 = require("@nestjs/common");
const add_appointment_service_1 = require("./add-appointment.service");
const add_appointment_entity_1 = require("./entities/add-appointment.entity");
const auth_guard_1 = require("../auth/auth.guard");
let AddAppointmentController = class AddAppointmentController {
    constructor(addAppointmentService) {
        this.addAppointmentService = addAppointmentService;
    }
    create(add_appointment) {
        add_appointment.payment_mode =
            add_appointment.payment_mode.toLocaleLowerCase();
        if (add_appointment.payment_mode != 'cash' &&
            add_appointment.payment_mode != 'card' &&
            add_appointment.payment_mode != 'upi' &&
            add_appointment.payment_mode != 'neft' &&
            add_appointment.payment_mode != 'paylater' &&
            add_appointment.payment_mode != 'online' &&
            add_appointment.payment_mode != 'net_banking') {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: 'Invalid payment mode. Please use one of the following: cash, card, upi, neft, paylater,online.',
            };
        }
        return this.addAppointmentService.create(add_appointment);
    }
    findAll() {
        return this.addAppointmentService.findAll();
    }
    findOne(id, hospital_id) {
        return this.addAppointmentService.findOne(id, hospital_id);
    }
    update(id, add_appointment) {
        add_appointment.payment_mode =
            add_appointment.payment_mode.toLocaleLowerCase();
        if (add_appointment.payment_mode != 'cash' &&
            add_appointment.payment_mode != 'card' &&
            add_appointment.payment_mode != 'upi' &&
            add_appointment.payment_mode != 'neft' &&
            add_appointment.payment_mode != 'paylater' &&
            add_appointment.payment_mode != 'online' &&
            add_appointment.payment_mode != 'net_banking') {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: 'Invalid payment mode. Please use one of the following: cash, card, upi, neft, paylater,online.',
            };
        }
        return this.addAppointmentService.update(+id, add_appointment);
    }
    remove(id, hos_id) {
        return this.addAppointmentService.remove(id, hos_id);
    }
    async setStatusToApproved(appointment_id, hos_id) {
        return await this.addAppointmentService.set_status_to_approved(appointment_id, hos_id);
    }
    cancelAppointment(id, add_appointment) {
        return this.addAppointmentService.cancelAppointment(id, add_appointment);
    }
    async findAllDesig(limit, page, filter, search, hosp_id) {
        try {
            const final_output = await this.addAppointmentService.findappointment(limit || 10, page || 1, filter, search, hosp_id);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalPages: Math.ceil(final_output.total / final_output.limit),
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: 'No appointments found',
                    data: [],
                    total: 0,
                    limit: limit,
                    page: page,
                    totalPages: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async V3findAllDesig(limit, page, filter, search, hosp_id) {
        try {
            if (!filter) {
                return {
                    status_code: process.env.ERROR_STATUS_CODE,
                    status: process.env.ERROR_STATUS,
                    message: process.env.ERROR_MESSAGE_PARAM_MISSING,
                };
            }
            const filterArray = filter.split('|');
            for (const filterItem of filterArray) {
                const [key, value] = filterItem.split(':');
                if (key.toLowerCase() != 'period') {
                    return {
                        status_code: process.env.ERROR_STATUS_CODE,
                        status: process.env.ERROR_STATUS,
                        message: process.env.ERROR_MESSAGE_PARAM_MISSING,
                    };
                }
            }
            const final_output = await this.addAppointmentService.V3findappointment(limit || 10, page || 1, filter, search, hosp_id);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: 'No appointments found',
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async paymentUpdate(appointment_id, add_appointment_payment) {
        if (!appointment_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: 'Appointment ID is required',
            };
        }
        if (add_appointment_payment.payment_mode.toLocaleLowerCase() != 'cash' &&
            add_appointment_payment.payment_mode.toLocaleLowerCase() != 'card' &&
            add_appointment_payment.payment_mode.toLocaleLowerCase() !=
                'net_banking' &&
            add_appointment_payment.payment_mode.toLocaleLowerCase() != 'upi') {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: 'Enter Correct Payment Method',
            };
        }
        if (!add_appointment_payment.Hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: 'Enter Hospital ID',
            };
        }
        if (!add_appointment_payment.payment_method) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (add_appointment_payment.payment_mode.toLocaleLowerCase() == 'card' &&
            !add_appointment_payment.card_division &&
            !add_appointment_payment.card_bank_name &&
            !add_appointment_payment.card_type &&
            !add_appointment_payment.card_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (add_appointment_payment.payment_mode.toLocaleLowerCase() ==
            'net_banking' &&
            !add_appointment_payment.net_banking_division &&
            !add_appointment_payment.net_banking_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (add_appointment_payment.payment_mode.toLocaleLowerCase() == 'upi' &&
            !add_appointment_payment.upi_id &&
            !add_appointment_payment.upi_transaction_id &&
            !add_appointment_payment.upi_bank_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        return this.addAppointmentService.updatePaymentDetails(appointment_id, add_appointment_payment);
    }
    async getPendingAppts(aayush_unique_id) {
        try {
            if (!aayush_unique_id) {
                return {
                    statusCode: 400,
                    status: process.env.ERROR_STATUS,
                    message: process.env.ERROR_MESSAGE_PARAM_MISSING,
                };
            }
            return await this.addAppointmentService.getPatAppoint(aayush_unique_id);
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.AddAppointmentController = AddAppointmentController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [add_appointment_entity_1.AddAppointment]),
    __metadata("design:returntype", void 0)
], AddAppointmentController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], AddAppointmentController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], AddAppointmentController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, add_appointment_entity_1.AddAppointment]),
    __metadata("design:returntype", void 0)
], AddAppointmentController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hos_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], AddAppointmentController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('set-status-to-approved'),
    __param(0, (0, common_1.Body)('appointment_id')),
    __param(1, (0, common_1.Body)('hos_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], AddAppointmentController.prototype, "setStatusToApproved", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/summa/cancel/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, add_appointment_entity_1.AddAppointment]),
    __metadata("design:returntype", void 0)
], AddAppointmentController.prototype, "cancelAppointment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllpage'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('filter')),
    __param(3, (0, common_1.Query)('search')),
    __param(4, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String, Number]),
    __metadata("design:returntype", Promise)
], AddAppointmentController.prototype, "findAllDesig", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v3/getAllpage'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('filter')),
    __param(3, (0, common_1.Query)('search')),
    __param(4, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String, Number]),
    __metadata("design:returntype", Promise)
], AddAppointmentController.prototype, "V3findAllDesig", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/update-appt-payment'),
    __param(0, (0, common_1.Query)('appointment_id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, add_appointment_entity_1.AddAppointmentPayment]),
    __metadata("design:returntype", Promise)
], AddAppointmentController.prototype, "paymentUpdate", null);
__decorate([
    (0, common_1.Get)('/get-pat-pending/appointments'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], AddAppointmentController.prototype, "getPendingAppts", null);
exports.AddAppointmentController = AddAppointmentController = __decorate([
    (0, common_1.Controller)('add-appointment'),
    __metadata("design:paramtypes", [add_appointment_service_1.AddAppointmentService])
], AddAppointmentController);
//# sourceMappingURL=add-appointment.controller.js.map