"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddAppointmentPatientQueueService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let AddAppointmentPatientQueueService = class AddAppointmentPatientQueueService {
    constructor(connection) {
        this.connection = connection;
    }
    async findall(doctor, date, global_shift_id, doctor_shift) {
        try {
            let q = `  select distinct appointment.id, concat(patients.patient_name,"(",patients.id,")") as patient_name,patients.mobileno as phone ,appointment.time,patients.email,
    appointment.date,appointment.source from appointment
        left join patients on appointment.patient_id = patients.id
            left join staff on  appointment.doctor = staff.id 
        left join doctor_shift on doctor_shift.staff_id = staff.id
        left join doctor_global_shift on doctor_global_shift.staff_id = staff.id
            where doctor = ? and date( appointment.date )= ? and appointment.global_shift_id = ? and doctor_shift.id = ?`;
            let v = [doctor, date, global_shift_id, doctor_shift];
            const patient_queue = await this.connection.query(q, v);
            return patient_queue;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findallpatientqueue(doctor, date, global_shift_id, doctor_shift, limit, page) {
        try {
            const offset = limit * (page - 1);
            let q = `  select distinct appointment.id, concat(patients.patient_name,"(",patients.id,")") as patient_name,patients.mobileno as phone ,appointment.time,patients.email,
      appointment.date,appointment.source from appointment
          left join patients on appointment.patient_id = patients.id
              left join staff on  appointment.doctor = staff.id 
          left join doctor_shift on doctor_shift.staff_id = staff.id
          left join doctor_global_shift on doctor_global_shift.staff_id = staff.id
              where doctor = ? and date( appointment.date )= ? and appointment.global_shift_id = ? and doctor_shift.id = ? LIMIT ? OFFSET ?`;
            let v = [doctor, date, global_shift_id, doctor_shift, Number(limit), Number(offset)];
            const patient_queue = await this.connection.query(q, v);
            let [totallist] = await this.connection.query(` SELECT COUNT(DISTINCT appointment.id) AS total_count
FROM appointment
LEFT JOIN patients ON appointment.patient_id = patients.id
LEFT JOIN staff ON appointment.doctor = staff.id 
LEFT JOIN doctor_shift ON doctor_shift.staff_id = staff.id
LEFT JOIN doctor_global_shift ON doctor_global_shift.staff_id = staff.id
WHERE doctor = ? 
AND DATE(appointment.date) = ? 
AND appointment.global_shift_id = ?
AND doctor_shift.id = ?`, [
                doctor,
                date,
                global_shift_id,
                doctor_shift
            ]);
            let appointment_patient_queue_variable = {
                details: patient_queue,
                total: totallist.total_count
            };
            return appointment_patient_queue_variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.AddAppointmentPatientQueueService = AddAppointmentPatientQueueService;
exports.AddAppointmentPatientQueueService = AddAppointmentPatientQueueService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], AddAppointmentPatientQueueService);
//# sourceMappingURL=add-appointment-patient_queue.service.js.map