"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddAppointmentPatientQueueController = void 0;
const common_1 = require("@nestjs/common");
const add_appointment_patient_queue_service_1 = require("./add-appointment-patient_queue.service");
const auth_guard_1 = require("../auth/auth.guard");
let AddAppointmentPatientQueueController = class AddAppointmentPatientQueueController {
    constructor(addAppointmentPatientQueueService) {
        this.addAppointmentPatientQueueService = addAppointmentPatientQueueService;
    }
    findAll(doctor, date, global_shift_id, doctor_shift_id) {
        return this.addAppointmentPatientQueueService.findall(doctor, date, global_shift_id, doctor_shift_id);
    }
    async findAllDesig(doctor, date, global_shift_id, doctor_shift, limit, page) {
        try {
            let final_output = await this.addAppointmentPatientQueueService.findallpatientqueue(doctor, date, global_shift_id, doctor_shift, limit || 10, page || 1);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
        return this.addAppointmentPatientQueueService.findallpatientqueue(doctor, date, global_shift_id, doctor_shift, limit, page);
    }
};
exports.AddAppointmentPatientQueueController = AddAppointmentPatientQueueController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('doctor')),
    __param(1, (0, common_1.Query)('date')),
    __param(2, (0, common_1.Query)('global_shift_id')),
    __param(3, (0, common_1.Query)('doctor_shift_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", void 0)
], AddAppointmentPatientQueueController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllpage'),
    __param(0, (0, common_1.Query)('doctor')),
    __param(1, (0, common_1.Query)('date')),
    __param(2, (0, common_1.Query)('global_shift_id')),
    __param(3, (0, common_1.Query)('doctor_shift')),
    __param(4, (0, common_1.Query)('limit')),
    __param(5, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], AddAppointmentPatientQueueController.prototype, "findAllDesig", null);
exports.AddAppointmentPatientQueueController = AddAppointmentPatientQueueController = __decorate([
    (0, common_1.Controller)('add-appointment-patient-queue'),
    __metadata("design:paramtypes", [add_appointment_patient_queue_service_1.AddAppointmentPatientQueueService])
], AddAppointmentPatientQueueController);
//# sourceMappingURL=add-appointment-patient_queue.controller.js.map