"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddAppointmentDoctorWiseService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let AddAppointmentDoctorWiseService = class AddAppointmentDoctorWiseService {
    constructor(connection) {
        this.connection = connection;
    }
    async findall(doctor, date) {
        try {
            let q = `select distinct appointment.id,appointment.doctor, concat(patients.patient_name,"(",patients.id,")") as patient_name,patients.mobileno as phone ,appointment.time,patients.email,
    appointment.date,appointment.source from appointment
    left join patients on appointment.patient_id = patients.id
    left join staff on  appointment.doctor = staff.id 
    where doctor = ? and date( appointment.date )= ?`;
            let v = [doctor, date];
            const doctor_wise = await this.connection.query(q, v);
            return doctor_wise;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findalldoctorwise(doctor, date, limit, page) {
        try {
            const offset = limit * (page - 1);
            let q = `select distinct appointment.id,appointment.doctor, concat(patients.patient_name,"(",patients.id,")") as patient_name,patients.mobileno as phone ,appointment.time,patients.email,
    appointment.date,appointment.source from appointment
    left join patients on appointment.patient_id = patients.id
    left join staff on  appointment.doctor = staff.id 
    where doctor = ? and date( appointment.date )= ? LIMIT ? OFFSET ?`;
            let v = [doctor, date, Number(limit), Number(offset)];
            const doctor_wise = await this.connection.query(q, v);
            let [totallist] = await this.connection.query(` SELECT COUNT(DISTINCT appointment.id) AS total_count
FROM appointment
LEFT JOIN patients ON appointment.patient_id = patients.id
LEFT JOIN staff ON appointment.doctor = staff.id 
WHERE doctor = ?
AND DATE(appointment.date) = ?`, [
                doctor,
                date,
            ]);
            let variable = {
                details: doctor_wise,
                total: totallist.total_count,
                limit: limit
            };
            return variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.AddAppointmentDoctorWiseService = AddAppointmentDoctorWiseService;
exports.AddAppointmentDoctorWiseService = AddAppointmentDoctorWiseService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], AddAppointmentDoctorWiseService);
//# sourceMappingURL=add-appointment-doctor_wise.service.js.map