"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddAppointmentDoctorWiseController = void 0;
const common_1 = require("@nestjs/common");
const add_appointment_doctor_wise_service_1 = require("./add-appointment-doctor_wise.service");
const auth_guard_1 = require("../auth/auth.guard");
let AddAppointmentDoctorWiseController = class AddAppointmentDoctorWiseController {
    constructor(addAppointmentDoctorWiseService) {
        this.addAppointmentDoctorWiseService = addAppointmentDoctorWiseService;
    }
    findAll(doctor, date) {
        return this.addAppointmentDoctorWiseService.findall(doctor, date);
    }
    async findAllDesig(doctor, date, limit, page) {
        try {
            let final_output = await this.addAppointmentDoctorWiseService.findalldoctorwise(doctor, date, limit || 10, page || 1);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / limit),
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: 'No appointments found',
                    data: [],
                    total: 0,
                    limit: limit,
                    page: page,
                    totalPages: 0
                };
            }
        }
        catch (error) {
        }
        return this.addAppointmentDoctorWiseService.findalldoctorwise(doctor, date, limit, page);
    }
};
exports.AddAppointmentDoctorWiseController = AddAppointmentDoctorWiseController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('doctor')),
    __param(1, (0, common_1.Query)('date')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], AddAppointmentDoctorWiseController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllpage'),
    __param(0, (0, common_1.Query)('doctor')),
    __param(1, (0, common_1.Query)('date')),
    __param(2, (0, common_1.Query)('limit')),
    __param(3, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], AddAppointmentDoctorWiseController.prototype, "findAllDesig", null);
exports.AddAppointmentDoctorWiseController = AddAppointmentDoctorWiseController = __decorate([
    (0, common_1.Controller)('add-appointment-doctor-wise'),
    __metadata("design:paramtypes", [add_appointment_doctor_wise_service_1.AddAppointmentDoctorWiseService])
], AddAppointmentDoctorWiseController);
//# sourceMappingURL=add-appointment-doctor_wise.controller.js.map